#include "rt_common.hlsl"

[shader("closesthit")]
void TriangleClosestHit(inout RayPayload payload, BuiltInTriangleIntersectionAttributes attr)
{
    float3 barycentrics = float3( 1 - attr.barycentrics.x - attr.barycentrics.y, attr.barycentrics.xy );
    payload.color = float4(barycentrics, 1.0);
}

[shader("anyhit")]
void TriangleAnyHit(inout RayPayload payload, BuiltInTriangleIntersectionAttributes attr)
{
    float3 barycentrics = float3( 1 - attr.barycentrics.x - attr.barycentrics.y, attr.barycentrics.xy );
    if (length(barycentrics - float3(0.33333, 0.33333, 0.33333)) < 0.25)
    {
        IgnoreHit();
    }
}
