//-------------------------------------------------------------------------------------------------------------------------------------------------------------
//
// Copyright 2023 Apple Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
//-------------------------------------------------------------------------------------------------------------------------------------------------------------

Texture2D<float4> inTexture : register(t0, space0);
SamplerState samp : register(s0, space1);

struct VertexIn
{
    float4 position : POSITION;
    float2 texcoord : TEXCOORD;
};

struct v2f
{
    float4 position : SV_Position;
    float2 uv0 : TEXCOORD0;
};

v2f MainVS(VertexIn vin)
{
    v2f o = (v2f)0;
    o.position = vin.position;
    o.uv0 = vin.texcoord;
    return o;
}

float4 MainFS(v2f vin) : SV_Target
{
    float4 color = inTexture.Sample(samp, vin.uv0);
    return color;
}
